@echo off
setlocal EnableDelayedExpansion

echo =====================================
echo FFMPEG -> FLAC (Stereo / 4.0)
echo =====================================

set OUTDIR=flac40_out
if not exist "%OUTDIR%" mkdir "%OUTDIR%"

for %%F in (*.aac *.ac3 *.wav) do (

    echo.
    echo Datei: %%F

    rem -------------------------------
    rem Kanalanzahl ermitteln
    rem -------------------------------
    set CH=
    for /f "delims=" %%C in ('
        ffprobe -v error -select_streams a:0 ^
        -show_entries stream^=channels ^
        -of default^=noprint_wrappers^=1:nokey^=1 "%%F"
    ') do set CH=%%C

    echo Kanaele: !CH!

    rem ===============================
    rem STEREO
    rem ===============================
    if "!CH!"=="2" (
        echo -> Stereo
        ffmpeg -y -i "%%F" ^
        -c:a flac -sample_fmt s16 ^
        "%OUTDIR%\%%~nF.flac"
    )

    rem ===============================
    rem 4.0 (aus 5.1)
    rem ===============================
    if "!CH!"=="6" (
        echo -> 4.0

        rem Front: L + R + (Center -3dB) + LFE, mit True-Peak-Limiter
        ffmpeg -y -i "%%F" ^
        -filter_complex ^
        "pan=stereo|c0=c0+0.707*c2+c3|c1=c1+0.707*c2+c3,alimiter=limit=0.99" ^
        -c:a flac -sample_fmt s16 ^
        "%OUTDIR%\%%~nF_1front.flac"

        rem Rear unveraendert
        ffmpeg -y -i "%%F" ^
        -filter_complex "pan=stereo|c0=c4|c1=c5" ^
        -c:a flac -sample_fmt s16 ^
        "%OUTDIR%\%%~nF_2rear.flac"
    )
)

echo.
echo Fertig.
pause
